unit glapp;

interface

uses
 Windows
 ,dglopengl
 ,glwinvar  //access variables to control glwin.pas
 ;

var
  xspeed, yspeed : single;

procedure gldraw; //draw the scene
procedure glinit; //init the scene
procedure glexit; //exit the scene
procedure glanim; //set advance animations
procedure ProcessKeys;
procedure ProcessMouseClick;
procedure ProcessMouseMove;

implementation

//------------------------------------------------------------------
//  Draw Your OpenGL Scene
//------------------------------------------------------------------
procedure glDraw();
begin
  //Add Code here to execute on screen redraw/idle
 // Flush the OpenGL Buffer
 glFlush();
end;

//------------------------------------------------------------------
//  Initialise Your OpenGL Scene
//------------------------------------------------------------------
procedure glInit();
begin
  ReadExtensions; //read in and setup extensions to opengl like multitexture...
  //Add Code here to execute on init of application
  //Animation FPS TIMER  (10 = fps);
  SetTimer(h_Wnd, FPS_ANIM_TIMER, round( (10 / 600) * 1000), nil);
end;

//------------------------------------------------------------------
//  De-Initialise Your OpenGL Scene
//------------------------------------------------------------------
procedure glexit;
begin
 //Add Code here to execute on exit of application
end;

//------------------------------------------------------------------
//  Set or advance animations
//------------------------------------------------------------------
procedure glanim;
begin
  //Add Code here to advance animations
end;

//------------------------------------------------------------------
//  Processes all the mouse move
//------------------------------------------------------------------
procedure ProcessMouseMove();
begin
  if MouseMove then
  begin
    // Add Code here to execute on mouse move
    MouseMove := False;
  end;
end;

//------------------------------------------------------------------
//  Processes all the mouse clicks
//------------------------------------------------------------------
procedure ProcessMouseClick;
var
  viewport: array [0..3] of GLint;
  pixel: array [0..2] of GLubyte;
  pickedid: integer;
  pickedname: string;

begin
  case MouseButton of
  1: // Left Mouse Button
    begin
      // Add code to execute on mouse click
      MouseButton := 0; // Cancel our mouse click (To use this procedure as a mouse down event remove this line)
    end;
  2: // Right Mouse Button
    begin
      // Add code to execute on mouse click
      MouseButton := 0; // Cancel our mouse click (To use this procedure as a mouse down event remove this line)
    end;
  3: // Middle Mouse Button
    begin
      // Add code to execute on mouse click
      MouseButton := 0;  // Cancel our mouse click (To use this procedure as a mouse down event remove this line)
    end;
  end;
end;

//------------------------------------------------------------------
//  Processes all the keystrokes
//------------------------------------------------------------------
procedure ProcessKeys;
begin
  if (keys[VK_UP])    then xspeed := xspeed - 0.002;
  if (keys[VK_DOWN])  then xspeed := xspeed + 0.002;
  if (keys[VK_RIGHT]) then yspeed := yspeed + 0.002;
  if (keys[VK_LEFT])  then yspeed := yspeed - 0.002;
end;

end.
