unit glapp;

interface

uses
 Windows
 ,sysutils
 ,dglopengl
 ,glwinvar  //access variables to control glwin.pas
 ,gl3ds
 ,glmath
 ,glmatrix
 ;

var
  xspeed, yspeed : single;
  scene: TAll3dsMesh;
  LP: array [0..3] of GLfloat = (-4, 0, -150, 1);    //light possition
  LDIFF: array [0..3] of GLfloat = (1, 1, 1, 0); //light diffuse color
  LAMBI: array [0..3] of GLfloat = (1, 1, 1, 0); //light diffuse color
  LSPEC: array [0..3] of GLfloat = (1, 1, 1, 0); //light diffuse color
  invmatrix: TMatrix; //inv matrix for bumpmap light calc...
  time: Single = 0;

procedure gldraw; //draw the scene
procedure glinit; //init the scene
procedure glexit; //exit the scene
procedure glanim; //set advance animations
procedure ProcessKeys;
procedure ProcessMouseClick;
procedure ProcessMouseMove;

implementation

//------------------------------------------------------------------
//  Draw Your OpenGL Scene
//------------------------------------------------------------------
procedure glDraw();
begin
 //Add Code here to execute on screen redraw/idle
 glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);    // Clear The Screen And The Depth Buffer
 glLoadIdentity();                                       // Reset The View


 Time := GetTickCount / 1000.0;
 //set light position
 lp[0]:=Sin(Time * 1.0)*5;
 lp[1]:=(Sin(Time * 1.3)*5);
 //lp[0]:=lp[0]+0.1;
 glLightfv(GL_LIGHT0, GL_POSITION, @lp); //position light

 gltranslatef(0,0,-20); //simple set camera...
 glrotatef(ElapsedTime/90,1,1,1);
// glrotatef(270,1,0,0);

 //prepare bumpmapping (should this be moved to gl3ds.pas?)
 //get the light position
 objlightpos.x:=lp[0];
 objlightpos.y:=lp[1];
 objlightpos.z:=lp[2];
 // Get the inverse model matrix
 glPushMatrix;
  glLoadIdentity;
  glGetFloatv(GL_MODELVIEW_MATRIX, @InvMatrix);
 glPopMatrix;
 //Get the object space light vector
 ObjLightPos := vectortransform(objlightpos,InvMatrix);

 scene.render; //render the mesh...

end;

//------------------------------------------------------------------
//  Initialise Your OpenGL Scene
//------------------------------------------------------------------
procedure glInit();
begin
  DecimalSeparator:='.';
  ReadExtensions; //read in and setup extensions to opengl like multitexture...

  //Add Code here to execute on init of application
  glClearColor(0.0, 0.0, 0.0, 0.0); 	   // Black Background
  glShadeModel(GL_SMOOTH);                 // Enables Smooth Color Shading
  glClearDepth(1.0);                       // Depth Buffer Setup
  glEnable(GL_DEPTH_TEST);                 // Enable Depth Buffer
  glDepthFunc(GL_LESS);		           // The Type Of Depth Test To Do
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);   //Realy Nice perspective calculations
  glEnable(GL_TEXTURE_2D);                 // Enable Texture Mapping

  //set up opengl rendering
  glPolygonMode(GL_FRONT, GL_FILL{GL_LINE});
  glEnable(GL_CULL_FACE);
  glcullface(GL_BACK);
  glDisable(GL_NORMALIZE);

  //set up blending for transparency (and fake bumpmapping)
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


  //setup light(s) in the world
  glLightfv(GL_LIGHT0, GL_DIFFUSE, @LDIFF);
  glLightfv(GL_LIGHT0, GL_AMBIENT, @LAMBI);
  glLightfv(GL_LIGHT0, GL_SPECULAR, @LSPEC);
  glLightfv(GL_LIGHT0, GL_POSITION, @lp);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);

  //load 3ds with bumpmapped material
  scene:=TAll3dsMesh.Create(nil);
  scene.TexturePath:='textures\';
  scene.LoadFromFile('meshes\sc2.3ds');

  //Animation FPS TIMER  (10 = fps);
  SetTimer(h_Wnd, FPS_ANIM_TIMER, round( (10 / 600) * 1000), nil);
end;

//------------------------------------------------------------------
//  De-Initialise Your OpenGL Scene
//------------------------------------------------------------------
procedure glexit;
begin
 //Add Code here to execute on exit of application
 scene.free;
end;

//------------------------------------------------------------------
//  Set or advance animations
//------------------------------------------------------------------
procedure glanim;
begin
  //Add Code here to advance animations
  //if scene.NumSkeletons>=1 then
  //scene.Skeleton[0].AdvanceAnimation;
end;

//------------------------------------------------------------------
//  Processes all the mouse move
//------------------------------------------------------------------
procedure ProcessMouseMove();
begin
  //
end;

//------------------------------------------------------------------
//  Processes all the mouse clicks
//------------------------------------------------------------------
procedure ProcessMouseClick;
begin
  //
end;

//------------------------------------------------------------------
//  Processes all the keystrokes
//------------------------------------------------------------------
procedure ProcessKeys;


begin
  if (keys[VK_UP])    then xspeed := xspeed - 0.002;
  if (keys[VK_DOWN])  then xspeed := xspeed + 0.002;
  if (keys[VK_RIGHT]) then yspeed := yspeed + 0.002;
  if (keys[VK_LEFT])  then yspeed := yspeed - 0.002;
end;

end.
